capture program drop appendIndivVar
program define appendIndivVar

version 13.1
*! version 1.0 January 22, 2016

syntax , table(string)


display ""
display "Start of the program APPEND INDIVIDUAL VARIABLES"
which appendIndivVar
display ""
display "	Part 1: Checking that all the files used are available."

qui capture import excel `table'_SELECT.xls, sheet("Sheet1") firstrow clear
	if _rc!=0{
	display "	File `table'_SELECT.xls not found."
	display "	The program APPEND INDIVIDUAL VARIABLES was stopped."
	qui exit
	}
	
qui capture use `table', clear
	if _rc!=0{
	display "	File `table'.dta not found."
	display "	The program APPEND INDIVIDUAL VARIABLES was stopped."
	qui exit
	}

qui capture use VarSetup.dta, clear
	if _rc!=0{
	display "	File VarSetup.dta not found. Run the program IDSextended to create it."
	display "	The program APPEND INDIVIDUAL VARIABLES was stopped."
	qui exit
	}

qui capture use Chronicle.dta, clear
	if _rc!=0{
	display "	File Chronicle.dta not found. Run the program IDSextended to create it."
	display "	The program APPEND CONTEXTUAL VARIABLES was stopped."
	qui exit
	}	

	
	
	
display "	Part 2: Checking that individual types were selected in the Excel select files."

qui:{
import excel `table'_SELECT.xls, sheet("Sheet1") firstrow clear

keep Type Select Duration
tempfile selected
save `selected'

gen temp = (Select==1)
egen temp1 = sum(temp)
keep if _n==1
keep temp1
local temp2=temp1 
}

if `temp2'==0{
	display ""
	display "	No Types were selected in the file `table'_SELECT.xls."
	display "	The program APPEND INDIVIDUAL VARIABLES was stopped. Select Types and restart the program."
	qui exit
}



display "	Part 3: Appending selected types to the file Chronicle.dta."
qui:{


*Saving context identifying names (to link to Value_Id_C in the INDIVIDUAL or INDIVIDUAL_EXT tables)
use CONTEXT.dta, clear

keep if Type =="Name"
keep Id_C Value
rename Value ContextName

rename Id_C Value_Id_C

tempfile contname
save `contname',replace



use `table', clear
foreach varName in End_day End_month End_year Start_day Start_month Start_year Value_Id_C Year Month Day DayFrac{
capture confirm variable `varName'
	if _rc!=0{
	gen `varName' = .
	}
}
save `table',replace



*Values which are assigned using Start and End dates
use `table', clear

keep Id_I Type Value Year Month Day DayFrac End_day End_month End_year Start_day Start_month Start_year
capture replace DayFrac=0 if DayFrac==.
keep if Start_day!=. & Day==.
drop Day Month Year
rename Start_day Day
rename Start_month Month
rename Start_year Year
drop End_day End_month End_year
tempfile spellData

save `spellData', replace


use `table', clear
keep Id_I Type Value Year Month Day DayFrac End_day End_month End_year Start_day Start_month Start_year Value_Id_C Date_type
capture replace DayFrac=0 if DayFrac==.
keep if Start_day!=. & Day==.
drop Day Month Year
capture rename End_day Day
rename End_month Month
rename End_year Year
drop Start_day Start_month Start_year

capture duplicates drop
capture merge 1:1 Id_I Type Day Month Year DayFrac using `spellData'
	if _rc!=0{
	merge 1:1 Id_I Type Day Month Year using `spellData'
	}	
keep if _merge==1
drop _merge
replace Value = "-1"

append using `spellData'

tempfile spellData1
save `spellData1', replace


use `table', clear
keep if Start_day==.
capture append using `spellData1'

capture drop Start_day Start_month Start_year End_day End_month End_year

keep Id_I Type Value Day Month Year DayFrac Date_type Value_Id_C 

*Assigning values to Types which have no Value but have something specified in Value_Id_C
merge m:1 Value_Id_C using `contname'
drop if _merge ==2
drop _merge

replace Value = ContextName if Value_Id_C!=.
drop ContextName

merge m:1 Type using `selected', noreport nogen
keep if Select==1
drop Select Duration

drop Date_type Value_Id_C

tempfile Indiv_IndividualVar
save `Indiv_IndividualVar'

use Chronicle.dta, clear
append using `Indiv_IndividualVar'
save Chronicle.dta,replace
}





display "	Part 4: Appending selected types to the file VarSetup.dta."

qui:{
use `selected', clear
keep if Select==1
keep Type Duration
merge 1:m Type using `table'
keep if _merge==3
drop _merge

keep Type Value Value_Id_C Day Month Year Date_type Duration Start_day Start_month Start_year

tempfile selectedTable
save `selectedTable', replace
}

*Check that Date_type is unique within Types
qui{
use `selectedTable', clear
keep Type Date_type
duplicates drop
bysort Type: gen row = _N
egen temp = max(row)
local temp1 = temp 
}

if `temp1'>1{
display "Date_type is not unique within the following Types"
list Type if row>1
display "	The program APPEND INDIVIDUAL VARIABLES was stopped. Fix the problem and restart the program."
qui exit
}


qui:{

use `selectedTable', clear

*Generating the field Transition
gen Transition = "End" if Date_type=="Event"
capture replace Transition = "Invariant" if Transition=="" & Day==. & Month==. & Year==. & Start_day==. & Start_month==. & Start_year==.
if _rc!=0{
replace Transition = "Invariant" if Transition=="" & Day==. & Month==. & Year==. 
}
replace Transition = "Start" if Transition==""

keep Type Duration Transition
duplicates drop
}

*Check that NoFillDown OnStart DateFormat are unique within Types
qui {
bysort Type: gen row = _N
egen temp = max(row)
local temp1 = temp 
}

if `temp1'>1 {
display "At least one of the fields is not unique within the following Types"
list Type if row>1
br if row>1
display "	The program APPEND INDIVIDUAL VARIABLES was stopped. Fix the problem and restart the program."
qui exit
}

qui:{
drop row temp 

append using VarSetup.dta
save VarSetup.dta, replace


}



display ""
display "End of the program APPEND INDIVIDUAL VARIABLES"

end
